/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.world.processor;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public interface ISafeWorldModifier {
    default public FluidState getFluidStateSafe(LevelChunkSection chunkSection, BlockPos pos) {
        if (chunkSection == null) {
            return Fluids.f_76191_.m_76145_();
        }
        return chunkSection.m_63007_(SectionPos.m_123207_((int)pos.m_123341_()), SectionPos.m_123207_((int)pos.m_123342_()), SectionPos.m_123207_((int)pos.m_123343_()));
    }

    default public FluidState getFluidStateSafe(LevelReader world, BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        ChunkAccess chunk = world.m_6325_(chunkPos.f_45578_, chunkPos.f_45579_);
        int sectionYIndex = world.m_151564_(pos.m_123342_());
        LevelChunkSection chunkSection = chunk.m_183278_(sectionYIndex);
        return this.getFluidStateSafe(chunkSection, pos);
    }

    default public Optional<BlockState> getBlockStateSafe(LevelChunkSection chunkSection, BlockPos pos) {
        if (chunkSection == null) {
            return Optional.empty();
        }
        return Optional.of(chunkSection.m_62982_(SectionPos.m_123207_((int)pos.m_123341_()), SectionPos.m_123207_((int)pos.m_123342_()), SectionPos.m_123207_((int)pos.m_123343_())));
    }

    default public Optional<BlockState> getBlockStateSafe(LevelReader world, BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        ChunkAccess chunk = world.m_6325_(chunkPos.f_45578_, chunkPos.f_45579_);
        int sectionYIndex = world.m_151564_(pos.m_123342_());
        LevelChunkSection chunkSection = chunk.m_183278_(sectionYIndex);
        return this.getBlockStateSafe(chunkSection, pos);
    }

    default public boolean isBlockStateAirSafe(LevelReader world, BlockPos pos) {
        Optional<BlockState> blockState = this.getBlockStateSafe(world, pos);
        return blockState.isPresent() && blockState.get().m_60795_();
    }

    default public boolean isMaterialLiquidSafe(LevelReader world, BlockPos pos) {
        Optional<BlockState> blockState = this.getBlockStateSafe(world, pos);
        return blockState.isPresent() && blockState.get().m_60767_().m_76332_();
    }

    default public Optional<BlockState> setBlockStateSafe(LevelChunkSection chunkSection, BlockPos pos, BlockState state) {
        if (chunkSection == null) {
            return Optional.empty();
        }
        return Optional.of(chunkSection.m_62991_(SectionPos.m_123207_((int)pos.m_123341_()), SectionPos.m_123207_((int)pos.m_123342_()), SectionPos.m_123207_((int)pos.m_123343_()), state, false));
    }

    default public Optional<BlockState> setBlockStateSafe(LevelReader world, BlockPos pos, BlockState state) {
        ChunkPos chunkPos = new ChunkPos(pos);
        ChunkAccess chunk = world.m_6325_(chunkPos.f_45578_, chunkPos.f_45579_);
        int sectionYIndex = chunk.m_151564_(pos.m_123342_());
        LevelChunkSection chunkSection = chunk.m_183278_(sectionYIndex);
        return this.setBlockStateSafe(chunkSection, pos, state);
    }
}

